/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.nickhider;

import club.sk1er.nickhider.NickHider;
import gg.essential.vigilance.Vigilant;
import gg.essential.vigilance.data.Property;
import gg.essential.vigilance.data.PropertyType;
import java.io.File;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Session;
import org.apache.commons.lang3.RandomStringUtils;

public class NickHiderConfig
extends Vigilant {
    @Property(type=PropertyType.SWITCH, name="Master Toggle", description="Completely toggle NickHider functionality.", category="General", triggerActionOnInitialization=false)
    public static boolean masterEnabled = true;
    @Property(type=PropertyType.TEXT, name="Pseudo Key", description="Utilize a unique string to generate player names.\nThis can be used to identify the same player if someone else has the same pseudo key.", category="General", protectedText=true, triggerActionOnInitialization=false)
    public static String pseudoKey = RandomStringUtils.random((int)6, (boolean)true, (boolean)true);
    @Property(type=PropertyType.SWITCH, name="Hide Your Nick", description="Hide your assigned nick.", category="General", subcategory="Usernames", triggerActionOnInitialization=false)
    public static boolean hideOwnNick = true;
    @Property(type=PropertyType.SWITCH, name="Hide Other Usernames", description="Hide other players' usernames.", category="General", subcategory="Usernames", triggerActionOnInitialization=false)
    public static boolean hideOtherNames = true;
    @Property(type=PropertyType.SWITCH, name="Skin Hiding", description="Completely toggle showing other player's skins.", category="General", subcategory="Skins")
    public static boolean skinHiding = true;
    @Property(type=PropertyType.SWITCH, name="Hide Player Skins", description="Use a Steve/Alex skin instead of player's regular skins.", category="General", subcategory="Skins")
    public static boolean hidePlayerSkins = false;
    @Property(type=PropertyType.SWITCH, name="Global Skin", description="Make other players use your skin instead of Steve/Alex.\n\u00a7eRequires Hide Player Skins.", category="General", subcategory="Skins")
    public static boolean globalSkin = false;
    @Property(type=PropertyType.SWITCH, name="Show Real Skin", description="Show your own skin instead of Steve/Alex.", category="General", subcategory="Skins")
    public static boolean realSkin = true;
    @Property(type=PropertyType.TEXT, name="Nick Prefix", description="Change what's said before the chosen word.", category="General", subcategory="Usernames", triggerActionOnInitialization=false)
    public static String prefix = "Player-";
    @Property(type=PropertyType.TEXT, name="Nick Suffix", description="Change what's said after the chosen word.", category="General", subcategory="Usernames", triggerActionOnInitialization=false)
    public static String suffix = "";

    @Property(type=PropertyType.BUTTON, name="Clear Cache", description="Clear name cache.", category="General")
    public void clearCache() {
        NickHider.INSTANCE.reset();
    }

    @Property(type=PropertyType.BUTTON, name="Reset Cached Session", description="Reset the cached session.", category="General")
    public void resetCachedSession() {
        Session session = Minecraft.func_71410_x().func_110432_I();
        NickHider.INSTANCE.setSession(session);
        NickHider.INSTANCE.setProfile(session.func_148256_e());
    }

    public NickHiderConfig() {
        super(new File("./nickhider.toml"));
        this.initialize();
        Consumer<Object> reset = toggle -> NickHider.INSTANCE.reset();
        Arrays.asList("masterEnabled", "pseudoKey", "hideOwnNick", "hideOtherNames", "prefix", "suffix").forEach(property -> this.registerListener((String)property, reset));
    }
}

